using System;

namespace gov.va.med.vbecs.BOL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/16/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Specimen business object class</summary>

	#endregion

	public class PatientUnitSelectionMessage:BaseBusinessObject
	{

		#region constructors

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2980"> 
		///		<ExpectedInput>EyeReadableId, ErrorMessage, boolean, Message text</ExpectedInput>
		///		<ExpectedOutput>PatientUnitSelectionMessage object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2981"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// PatientUnitSelectionMessage
		/// </summary>
		/// <param name="eyeReadableUnitID"></param>
		/// <param name="message"></param>
		/// <param name="overRideable"></param>
		/// <param name="messageText"></param>
		public PatientUnitSelectionMessage(string eyeReadableUnitID, Common.UC03UnitSelectErrorMessages message, bool overRideable, string messageText)
		{
			this._eyeReadableUnitID =  eyeReadableUnitID;
			this._message = message;
			this._overRideable = overRideable;
			this._messageText = messageText;

			_beep = BeepRequired(message);
		}

		#endregion


		#region variables

		private Common.UC03UnitSelectErrorMessages _message;
		private bool _overRideable;
		private string _messageText;
		private string _eyeReadableUnitID;
		private bool _beep;

		#endregion


		#region properties


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2982"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2992"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// EyeReabableUnitID
		/// </summary>
		public String EyeReabableUnitID
		{
			get
			{
				return _eyeReadableUnitID;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2993"> 
		///		<ExpectedInput>Common.UC03UnitSelectErrorMessages</ExpectedInput>
		///		<ExpectedOutput>Common.UC03UnitSelectErrorMessages</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3002"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Message
		/// </summary>
		public Common.UC03UnitSelectErrorMessages Message
		{
			get
			{
				return _message;
			}
			set
			{
				_message = value;
			}
		}
		

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3003"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3008"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// OverRideable
		/// </summary>
		public bool OverRideable
		{
			get
			{
				return _overRideable;
			}
			set
			{
				_overRideable = value;
			}
		}
		

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3012"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3013"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// MessageText
		/// </summary>
		public string MessageText
		{
			get
			{
				return _messageText;
			}
			set
			{
				_messageText = value;
			}
		}


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3016"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3017"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Beep
		/// </summary>
		public bool Beep
		{
			get
			{
				return _beep;
			}
		}

		#endregion


		#region methods
		

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3058"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>DataRow</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3059"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// LoadDataRowFromThis
		/// </summary>
		/// <param name="dtRow"></param>
		/// <returns></returns>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			return dtRow;
		}
		
		/// <summary>
		/// LoadFromDataRow
		/// </summary>
		/// <param name="dtRow"></param>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
		}



        private bool BeepRequired(Common.UC03UnitSelectErrorMessages message)
        {
            if (message == Common.UC03UnitSelectErrorMessages.BR306 ||
                message == Common.UC03UnitSelectErrorMessages.BR306Override ||
                message == Common.UC03UnitSelectErrorMessages.BR310 ||
                message == Common.UC03UnitSelectErrorMessages.BR310Override ||
                message == Common.UC03UnitSelectErrorMessages.BR312UnitFrozen ||
                message == Common.UC03UnitSelectErrorMessages.BR312UnitFrozenEmergencyIssue ||
                message == Common.UC03UnitSelectErrorMessages.BR314TransfusionRequirements ||
                message == Common.UC03UnitSelectErrorMessages.BR315UnitNotTyped ||
                message == Common.UC03UnitSelectErrorMessages.BR316ABORhConfirmation ||
                message == Common.UC03UnitSelectErrorMessages.BR321 ||
                message == Common.UC03UnitSelectErrorMessages.BR321Female ||
                message == Common.UC03UnitSelectErrorMessages.BR332CMVNegRequiredOverride ||
                // CR3260 start
                message == Common.UC03UnitSelectErrorMessages.BR332SickleCellAndCMVNegRequiredOverride ||
                message == Common.UC03UnitSelectErrorMessages.BR332SickleCellNegRequiredOverride ||
                message == Common.UC03UnitSelectErrorMessages.BR332CMVNegRequired ||
                message == Common.UC03UnitSelectErrorMessages.BR332SickleCellAndCMVNegRequired ||
                message == Common.UC03UnitSelectErrorMessages.BR332SickleCellNegRequired ||
                // cR3260 end
                message == Common.UC03UnitSelectErrorMessages.BR339BiohazardousWarningIndicator
                )
            {
                return true;
            }
            else
            {
                return false;
            }
        }

		#endregion
	}
}
